// Autor: Mislav Balunovic

#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <algorithm>
#include <vector>
#include <set>

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR (i, 0, n)
#define _ << " _ " <<
#define TRACE(x) cerr << #x << " = " << x << endl
#define debug(...) fprintf(stderr, __VA_ARGS__)
//#define debug
//#define TRACE(x)

using namespace std;

typedef long long llint;

const int MAXN = 50010;
const int MAX = 35;
const int MAXLEN = 20;

struct node {
  int val;
  int child[MAX];

  node() {
    val = 0;
    memset(child, -1, sizeof(child));
  }
};

int n, ptr, min_len = 1;
char s[MAXN][MAXLEN];
node v[MAXN * MAXLEN];
llint sol;

int main(void) {
  scanf("%d",&n);
  ptr = 1;
  REP(i, n) {
    scanf("%s",s[i]);
    int curr = 0;
    int m = (int)strlen(s[i]);
    REP(j, m) {
      if (v[curr].child[s[i][j] - 'a'] == -1)
	v[curr].child[s[i][j] - 'a'] = ptr++;
      curr = v[curr].child[s[i][j] - 'a'];
      ++v[curr].val;
    }
  }

  REP(i, n) {
    int m = (int)strlen(s[i]);
    REP(j, m - min_len + 1) {
      bool ok = true;
      FOR(k, j + 1, m - min_len + 1) {
	bool eq = true;
	REP(d, m - k)
	  if (s[i][k + d] != s[i][j + d])
	    eq = false;
	if (eq)
	  ok = false;
      }

      if (ok) {
	bool my_eq = true;
	REP(d, m - j)
	  if (s[i][d] != s[i][j + d])
	    my_eq = false;
	if (my_eq)
	  --sol;
	
	int curr = 0;
	FOR(k, j, m) {
	  if (v[curr].child[s[i][k] - 'a'] == -1) {
	    curr = -1;
	    break;
	  }
	  curr = v[curr].child[s[i][k] - 'a'];
	}
	if (curr != -1)
	  sol += v[curr].val;
      }
    }
  }

  printf("%lld\n",sol);
  
  return 0;
}
